﻿using System;
using System.Diagnostics;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VIMT.VirtualMeetingRoom.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.Delete
{
    /// <summary>
    /// Send to Video Visit Service step.
    /// </summary>
    public class DeleteMeetingRoomRequestStep : FilterBase<VirtualMeetingRoomDeleteStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VirtualMeetingRoomDeleteStateObject state)
        {
            if (state.UseFakeResponse) return;

            var ecVmrRequest = new VIMTVirtualDeleteMeetingRequest
            {
                // TODO - should get these values from CRM                           
                OrganizationName = state.OrganizationName,
                UserId = state.UserId,
                LogTiming = state.LogTimingEc,
                LogSoap = state.LogSoapEc,
                Debug = state.LogDebugEc,
                deletemeetingrequestInfo = new VIMTVirtualdeletemeetingrequest
                {
                    mcs_EncounterId = state.AppointmentId.ToString(),
                    mcs_MiscData = state.MiscDataForRequest
                }
            };

            // Call the Enterprise Component to send the meeting info to Vyopta
            try
            {
                var timer = new Stopwatch();
                timer.Start();
                var response = ecVmrRequest.SendReceive<VIMTVirtualDeleteMeetingResponse>(MessageProcessType.Local);
                timer.Stop();
                state.EcProcessingTimeMs += (int)timer.ElapsedMilliseconds;

                if (response.ExceptionOccured)
                {
                    state.ExceptionOccured = true;
                    state.ExceptionMessage = response.ExceptionMessage;
                }
                else
                {
                    if (response.VIMTVirtualDeleteMeetingResponseDataInfo != null)
                    {
                        state.MiscDataForResponse = response.VIMTVirtualDeleteMeetingResponseDataInfo.mcs_MiscData;
                    }
                    else
                    {
                        state.ExceptionOccured = true;
                        state.ExceptionMessage = "The VIMTVirtualDeleteMeetingResponseDataInfo response value is null";
                    }
                }
            }
            catch (Exception ex)
            {
                var exceptionMessage = ex.Message;
                exceptionMessage += Shared.PipelineUtilities.BuildErrorMessage(ex);

                state.ExceptionOccured = true;
                state.ExceptionMessage = exceptionMessage;
            }
        }
    }
}